#!/bin/bash

# Definiere das Zielverzeichnis
DEST_DIR="$HOME/qcad"

# Liste der zu verschiebenden Dateien
FILES=(
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadpdf.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadpolygon.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadproj.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadproscripts.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadproxies.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadshp.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadspatialindexpro.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadtrace.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcadtriangulation.so"
  "$HOME/opt/qcadcam-3.32.2-trial-linux-qt5.14-x86_64/plugins/libqcaddwg.so"
)

# Überprüfen, ob das Zielverzeichnis existiert, falls nicht, erstelle es
if [ ! -d "$DEST_DIR" ]; then
  echo "Das Zielverzeichnis $DEST_DIR existiert nicht. Es wird erstellt."
  mkdir -p "$DEST_DIR"
fi

# Schleife über die Dateien und verschiebe sie ins Zielverzeichnis
for file in "${FILES[@]}"; do
  if [ -f "$file" ]; then
    echo "Verschiebe $file nach $DEST_DIR"
    mv "$file" "$DEST_DIR/"
  else
    echo "Datei $file nicht gefunden, überspringe..."
  fi
done

echo "Verschieben abgeschlossen."
