/* minimal solution - reading gauge indicator (here a device from Absolute-System)
   @author torsten roehl
   @see this code is based on https://www.instructables.com/id/Interfacing-a-Digital-Micrometer-to-a-Microcontrol/
   (there is a little big in the code from instructables - only ocurs for high inch values! )
*/


/*  ADJUST AREA START  */
/* pin configuration */
int pinREQ = 5;
int pinDATA = 2;
int pinCLK = 3;

/* baudrate */
int bd = 9600;
/*  ADJUST AREA END  */

/* Keep FIXED! - data protocol format */
byte digits[13];

/* serial communication protocol */
byte cmd;
const byte PROTOCOL_REQ =  55;


void setup() {

  /*    SERIAL_8N1 (the default)  */
  Serial.begin(bd);

  pinMode(pinREQ, OUTPUT);
  pinMode(pinCLK, INPUT_PULLUP);
  pinMode(pinDATA, INPUT_PULLUP);
  digitalWrite(pinREQ, LOW); // set request at high

}

void loop() {


  if (Serial.available() > 0) {

    cmd =  Serial.read();

    switch (cmd) {

      case PROTOCOL_REQ:

        readDialGauge();
        send();
        break;

    }

  }

}


/*
   Read the dial gauge.
   After a call to this function the array digits[13] contains all data according to the data protocol.
   For normal data reading the first four digits should by all 'F', the function return false if this is not the case.
*/

boolean readDialGauge() {

  /**
     Generate request by making REQ active (low level)!
  */
  digitalWrite(pinREQ, HIGH); // generate set request

  /* read 13 nibble (52 bit) */
  for (int i = 0; i < 13; i++ ) {
    int digit = 0;
    for (int j = 0; j < 4; j++) {

      while ( digitalRead(pinCLK) == LOW) {}/* Wait for CLOCK=HIGH */
      while ( digitalRead(pinCLK) == HIGH) {} /* Wait for CLOCK=LOW  */

      bitWrite(digit, j /*pos*/, (digitalRead(pinDATA) & 0x1));
    }

    digits[i] = digit;
  }

  digitalWrite(pinREQ, LOW);


  /* d1-d4 should be all oxF */
  int header = digits[0] + digits[1] + digits[2] + digits[3];
  return header == 60 ? true : false;
}


/*
   This function send 13 Bytes via the serial interface.
   The method send the whole digimatic protocol for client side processing purpurses.
*/
void send() {

  for (int i = 0; i < 13; i++ ) {
    Serial.write(digits[i] );
  }

}



