
/**
 * @author torsten roehl
 * Serversoftware: dial_gauge_v01.ini 
 * Verwendete API: jssc.jar
 * Demoprogramm für eigene Erweiterungen
 */

import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;

public class DialGauge01 {

	public static void main(String[] args) throws InterruptedException, SerialPortTimeoutException {

		String dev = "/dev/ttyUSB0";
		if (args.length == 1)
			dev = args[0];

		SerialPort serialPort = new SerialPort(dev);

		try {

			serialPort.openPort();
			serialPort.setParams(9600, 8, 1, 0);
			System.out.println("...	initializing the serial port");
			Thread.sleep(4000); /* necessary, otherwise serial will fail!!! */

			byte REQ = 55; /* Protokoll */

			String strValue;
			String oldValue = "";

			while (serialPort.isOpened()) {

				// send request to read gauge value!
				boolean isReady = serialPort.writeByte(REQ);

				if (isReady) {

					byte[] buffer = serialPort.readBytes(13);
					strValue = DialGauge01.decodeDialGaugeAsString(buffer);

					if (!oldValue.equals(strValue))
						System.out.println("Messwert: " + strValue);
					oldValue = strValue;
				}

				Thread.sleep(10);
			}

			serialPort.closePort();

			System.out.println("port is closed!");
		} catch (SerialPortException ex) {
			System.out.println(ex);
		}
	}

	/*
	 * Working but q&d programming! 
	 * Auswertung fuer unsere Messuhr es gilt:
	 * Format (mm): ##.###    (3 Nachkommastellen)
	 * Format (inch): #.##### (5 Nachkommastellen)
	 */
	public static String decodeDialGaugeAsString(byte digits[]) {

		int units = digits[12]; // 0=mm or 1=inch
		String info = " (mm)";

		String str = "" + digits[5] + "" + digits[6] + "" + digits[7] + "" + digits[8] + "" + digits[9] + ""
				+ digits[10];

		/* mm */
		if (units == 0) {

			String s1 = str.substring(0, 3);

			if (s1.charAt(0) == '0')
				s1 = s1.substring(1);
			if (s1.charAt(0) == '0')
				s1 = s1.substring(1);

			String s2 = str.substring(3);
			str = s1 + "." + s2;

		}

		/* inch */
		if (units == 1) {
			info = " (inch)";
			String s1 = str.substring(0, 1);
			String s2 = str.substring(1);
			str = s1 + "." + s2;
		}

		/* sign */
		if (digits[4] == 8)
			str = "-" + str;

		return str + info;

	}

}
